;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(lib "reader.ss" "plai" "lang")
(define-type Expr
  (num (n number?))
  (id  (var symbol?))
  (add (left Expr?) (right Expr?))
  (ifc (condition Expr?) (body-then Expr?) (body-else Expr?))
  (fun (arg symbol?) (body Expr?))
  (app (fx Expr?) (param Expr?)))

;; parse:: sList -> Expr
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(symbol? sexp) (id sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(if) (ifc (parse (second sexp)) (parse (third sexp)) (parse (fourth sexp)))]
       [(lambda) (fun (first (second sexp)) (parse (third sexp)))]
       [else (app (parse (first sexp)) (parse (second sexp)))])]))

;; free-vars:: Expr -> list-of(symbol)
;; Devuelve la lista de variables libres (sin repetidos)
(define (free-vars expr) (list->set (free-vars* expr)))

;; free-vars*:: Expr -> list-of(symbol)
;; Devuelve la lista de variables libres (con repetidos)
(define (free-vars* expr)
  (type-case Expr expr
             (num (n) empty)
             (id (v) (list v))
             (add (l r) (append (free-vars* l) (free-vars* r)))
             (ifc (c bt be) (append (free-vars* c) (free-vars* bt) (free-vars* be)))
             (app (f a) (append (free-vars* f) (free-vars* a)))
             (fun (a b) (remove* (list a) (free-vars* b)))
             ))

;;list->set::List-of(symbol) -> List-of(symbol)
;;Recibe un multiconjunto y devuelve su conjunto
(define (list->set ls)
  (if (empty? ls) '() 
      (cons (first ls) (list->set (remove* (list (first ls)) ls)))))


(test (free-vars (parse '{+ a b})) '(a b))
(test (free-vars (parse '{lambda {x}
                              {+ x x}})) 
      '())
(test (free-vars (parse '{{lambda {x} {lambda {y} {+ x y}}} 
                          {if x x x}}))
      '(x))